implementation module listextensions

import	StdInt, StdBool, StdString, StdList, StdMisc

insertindex :: !(a -> a -> Bool) !a !u:[a] -> (!Int,!v:[a]), [u <= v]
insertindex r x ls = inserti r 0 x ls
where
	inserti :: !(a -> .(a -> .Bool)) !Int !a !u:[a] -> (!Int,!v:[a]), [u <= v]
	inserti r i x ls=:[y:ys]
	|	r x y		= (    i,[x:ls])
	|	otherwise	= (index,[y:list]) with (index,list) = inserti r (inc i) x ys
	inserti _ i x _	= (    i,[x])

removeindex :: !a !u:[a] -> (!Int,!v:[a]) | ==, toString a, [u <= v]
removeindex e xs = removei e xs 0
where
	removei :: !a !u:[a] !Int -> (!Int,v:[a]) | ==, toString a, [u <= v]
	removei e [x:xs] i
	|	x==e		= (i,xs)
	|	otherwise	= (j,[x:res]) with (j,res) = removei e xs (inc i)
	removei e _ _	= abort ("Err: "+++toString e+++" not removable!")

moveinlist :: !Int !Int !.[a] -> [a]
moveinlist src dest l				// should be in StdList
	| src < dest	= removeAt src beforedest ++ [l!!src : atdest]
	| src > dest	= beforedest ++ [l!!src : removeAt (src - dest) atdest]
	| otherwise		= l
where
	(beforedest,atdest)	= splitAt dest l	

splitby :: a !.[a] -> [.[a]] | == a
splitby x ys			= case rest of [] -> [firstpart]; [r:rs] -> [firstpart:splitby x rs]
where
	(firstpart,rest)	= span ((<>) x) ys
